/*
 * Decompiled with CFR 0.152.
 */
package com.android.gymchina.framework.network.api;

import android.support.annotation.NonNull;
import com.android.gymchina.framework.network.api.BaseApi;
import com.android.gymchina.framework.utils.CastUtil;
import java.util.HashMap;

public class ApiCreator {
    private HashMap<String, BaseApi> apiMap = new HashMap();

    public static ApiCreator instance() {
        return Singleton.INSTANCE;
    }

    public HashMap<String, BaseApi> getMap() {
        return this.apiMap;
    }

    public <T extends BaseApi> void putApi(String key, T api) {
        this.apiMap.put(key, api);
    }

    public <T extends BaseApi> T createApi(@NonNull Class<T> apiClass) throws InstantiationException, IllegalAccessException {
        BaseApi api = this.apiMap.get(apiClass.getSimpleName());
        if (api != null) {
            return (T)((BaseApi)CastUtil.cast(api));
        }
        BaseApi t = (BaseApi)apiClass.newInstance();
        this.apiMap.put(apiClass.getSimpleName(), t);
        return (T)t;
    }

    private static class Singleton {
        private static final ApiCreator INSTANCE = new ApiCreator();

        private Singleton() {
        }
    }
}

