/*
 * Copyright (c) 2015-present Alipay.com, https://www.alipay.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package cn.com.antcloud.api.common;

import com.alibaba.fastjson.JSON;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.*;
import java.util.regex.Pattern;

public class GwKeyValues {

    public static Map<String, String> toMap(Object o) {
        // TODO: 低效实现
        SDKUtils.checkNotNull(o);
        String jsonString = GwJsons.toString(o);
        return toMap(jsonString);
    }

    public static Map<String, String> toMap(String json) {
        SDKUtils.checkNotNull(json);
        Object jsonObject = JSON.parseObject(json);
        SDKUtils.checkArgument(jsonObject instanceof Map);
        Map<String, String> map = new LinkedHashMap<String, String>();
        toMap(map, "", jsonObject);
        return map;
    }

    private static void toMap(Map<String, String> result, String path, Object obj) {
        if (obj instanceof Map) {
            Map<String, Object> map = (Map<String, Object>) obj;
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                toMap(result, path + "." + entry.getKey(), entry.getValue());
            }
        } else if (obj instanceof List) {
            List<Object> list = (List<Object>) obj;
            for (int i = 0; i < list.size(); i++) {
                toMap(result, path + "." + (i + 1), list.get(i));
            }
        } else {
            if (obj != null) {
                result.put(path.substring(1), String.valueOf(obj));
            }
        }
    }

    public static <T> T toObject(Map<String, String> map, Class<T> clazz) {
        SDKUtils.checkNotNull(clazz);

        return GwJsons.parse(toJSONString(map, clazz), clazz);
    }

    public static <T> T toObject(Map<String, String> map, Type type) {
        SDKUtils.checkNotNull(type);

        Class<?> clazz;
        if (type instanceof Class<?>) {
            clazz = (Class<?>) type;
        } else {
            clazz = (Class<?>) ((ParameterizedType) type).getRawType();
        }

        return GwJsons.parse(toJSONString(map, clazz), type);
    }

    public static String toJSONString(Map<String, String> map, Class<?> clazz) {
        SDKUtils.checkNotNull(map);
        SDKUtils.checkNotNull(clazz);

        Map<String, Object> result = new HashMap<String, Object>();

        for (Map.Entry<String, String> entry : map.entrySet()) {
            String[] parts = entry.getKey().split("\\.");

            Object node = result;
            for (int pi = 1; pi < parts.length; pi++) {
                String part = parts[pi];

                if (get(node, parts[pi - 1]) != null) {
                    node = get(node, parts[pi - 1]);
                } else {
                    Object child;
                    // TODO: not good
                    if (Pattern.matches("\\d+", part)) {
                        child = new ArrayList<Object>();
                    } else {
                        child = new HashMap<String, Object>();
                    }
                    set(node, parts[pi - 1], child);
                    node = child;
                }
            }
            get(node, parts[parts.length - 1]);
            set(node, parts[parts.length - 1], entry.getValue());
        }
        return JSON.toJSONString(result);
    }

    private static void set(Object o, String key, Object value) {
        if (o instanceof Map) {
            ((Map) o).put(key, value);
        } else {
            List<Object> list = (List<Object>) o;
            int index = Integer.parseInt(key) - 1;
            //            while (index >= list.size()) {
            //                list.add(null);
            //            }
            list.set(index, value);
        }
    }

    private static Object get(Object o, String key) {
        if (o instanceof Map) {
            return ((Map) o).get(key);
        } else {
            List<Object> list = (List<Object>) o;
            int index = Integer.parseInt(key) - 1;
            while (index >= list.size()) {
                list.add(null);
            }

            return ((List) o).get(index);
        }
    }

}
