/*
 * Copyright (c) 2015-present Alipay.com, https://www.alipay.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package cn.com.antcloud.api.common;

import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

import static cn.com.antcloud.api.common.SDKConstants.BASE64URL;

public class GwHelper {
    /**
     * 提供给产品使用，用于校验输入值的签名值、输入参数的正确性
     *
     * @param requestParam the request param
     * @param accessSecret the access secret
     * @return the map
     * @throws Exception the exception
     */
    public static Map<String, String> parseRequestParam(Map<String, String[]> requestParam,
                                                        String accessSecret) throws Exception {
        Map<String, String> map = new HashMap<String, String>();

        // check wrong params
        for (String key : requestParam.keySet()) {
            String[] values = requestParam.get(key);
            if (values.length != 1) {
                throw new Exception("wrong params");
            }
            map.put(key, values[0]);
        }
        return parseRequestParamMap(map, accessSecret);
    }

    public static Map<String, String> parseRequestParamMap(Map<String, String> requestParam,
                                                           String accessSecret) throws Exception {
        Map<String, String> result = new HashMap<String, String>();

        // check missing params
        if (!requestParam.keySet().contains("sign_type")
            || !requestParam.keySet().contains("sign")) {
            throw new Exception("missing params");
        }

        // check wrong params
        for (String key : requestParam.keySet()) {
            String values = requestParam.get(key);
            if (!"sign".equals(key)) {
                result.put(key, values);
            }
        }

        //check signature
        String signType = requestParam.get("sign_type");
        String sign = requestParam.get("sign");
        Charset charset = Charset.forName("UTF-8");

        String calculateSign = GwSigns.sign(result, signType, accessSecret, charset);
        if (!calculateSign.equals(sign)) {
            throw new Exception("invalidate signature");
        }

        return result;
    }

    public static String base64ParamValue(String base64String) {
        return BASE64URL + base64String;
    }
}
