/*
 * Copyright (c) 2015-present Alipay.com, https://www.alipay.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package cn.com.antcloud.api.common;

import com.alibaba.fastjson.JSONObject;

import java.lang.reflect.Type;

public class BaseClientResponse {

    private JSONObject data;

    @Deprecated
    protected static <T extends BaseClientResponse> T success(T t, Object o) {
        SDKUtils.checkNotNull(o);

        JSONObject jsonObject = GwJsons.toJSON(o);
        jsonObject.put(SDKConstants.ParamKeys.RESULT_CODE, SDKConstants.ResultCodes.OK);

        t.setData(jsonObject);

        return t;
    }

    protected static <T extends BaseClientResponse> T success(T t, BaseClientRequest request,
                                                              Object o) {
        SDKUtils.checkNotNull(o);

        JSONObject jsonObject = GwJsons.toJSON(o);
        jsonObject.put(SDKConstants.ParamKeys.RESULT_CODE, SDKConstants.ResultCodes.OK);
        jsonObject.put(SDKConstants.ParamKeys.REQ_MSG_ID, request.getReqMsgId());

        t.setData(jsonObject);

        return t;
    }

    @Deprecated
    public static <T extends BaseClientResponse> T error(T t, String resultCode, String resultMsg) {
        SDKUtils.checkNotNull(resultCode);
        SDKUtils.checkNotNull(resultMsg);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put(SDKConstants.ParamKeys.RESULT_CODE, resultCode);
        jsonObject.put(SDKConstants.ParamKeys.RESULT_MSG, resultMsg);

        t.setData(jsonObject);

        return t;
    }

    public static <T extends BaseClientResponse> T error(T t, BaseClientRequest request,
                                                         String resultCode, String resultMsg) {
        SDKUtils.checkNotNull(resultCode);
        SDKUtils.checkNotNull(resultMsg);

        JSONObject jsonObject = new JSONObject();
        jsonObject.put(SDKConstants.ParamKeys.RESULT_CODE, resultCode);
        jsonObject.put(SDKConstants.ParamKeys.RESULT_MSG, resultMsg);
        jsonObject.put(SDKConstants.ParamKeys.REQ_MSG_ID, request.getReqMsgId());

        t.setData(jsonObject);

        return t;
    }

    public boolean isSuccess() {
        return SDKConstants.ResultCodes.OK.equals(getResultCode());
    }

    public String getReqMsgId() {
        return data.getString(SDKConstants.ParamKeys.REQ_MSG_ID);
    }

    public void setReqMsgId(String reqMsgId) {
        data.put(SDKConstants.ParamKeys.REQ_MSG_ID, reqMsgId);
    }

    public String getResultCode() {
        return data.getString(SDKConstants.ParamKeys.RESULT_CODE);
    }

    public String getResultMsg() {
        return data.getString(SDKConstants.ParamKeys.RESULT_MSG);
    }

    public String getData() {
        return GwJsons.toString(data);
    }

    public void setData(String data) {
        this.data = GwJsons.parse(data);
    }

    public void setData(JSONObject data) {
        this.data = data;
    }

    public <T> T getData(Class<T> clazz) {
        return GwJsons.parse(data, clazz);
    }

    public <T> T getData(Type type) {
        return GwJsons.parse(data, type);
    }

}
