/*
 * Copyright (c) 2015-present Alipay.com, https://www.alipay.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package cn.com.antcloud.api;

import cn.com.antcloud.api.acapi.AntCloudHttpClient;
import cn.com.antcloud.api.antcloud.*;
import cn.com.antcloud.api.antcloud.rest.AntCloudRestClient;
import cn.com.antcloud.api.antcloud.rest.AntCloudRestClientRequest;
import cn.com.antcloud.api.antcloud.rest.AntCloudRestClientResponse;
import cn.com.antcloud.api.product.*;

public class AntFinTechApiClient {

    private AntCloudClient     antCloudClient;
    private AntCloudProdClient antCloudProdClient;
    private AntCloudRestClient antCloudRestClient;

    public AntFinTechApiClient(AntFinTechProfile profile) {
        AntCloudHttpClient client;
        if (profile.getHttpClient() == null){
            client = new AntCloudHttpClient(profile.getHttpConfig());
        }else{
            client = profile.getHttpClient();
        }
        String securityToken = profile.getStsConfig() != null ? profile.getStsConfig().getSecurityToken() : null;

        // set basic params
        AntCloudClient.Builder antCloudClientBuilder = AntCloudClient.newBuilder()
            .setEndpoint(profile.getBaseUrl() + "gateway.do")
            .setAccess(profile.getAccessKey(), profile.getAccessSecret())
            .setCheckSign(profile.isCheckSign()).setEnableAutoRetry(profile.isEnableAutoRetry())
            .setAutoRetryLimit(profile.getAutoRetryLimit())
            .setHttpClient(client).setSecurityToken(securityToken);
        AntCloudProdClient.Builder antCloudProdClientBuilder = AntCloudProdClient.newBuilder()
            .setEndpoint(profile.getBaseUrl() + "gateway.do")
            .setAccess(profile.getAccessKey(), profile.getAccessSecret())
            .setCheckSign(profile.isCheckSign()).setEnableAutoRetry(profile.isEnableAutoRetry())
            .setAutoRetryLimit(profile.getAutoRetryLimit())
            .setHttpClient(client).setSecurityToken(securityToken);
        AntCloudRestClient.Builder antCloudRestClientBuilder = AntCloudRestClient.newBuilder()
            .setEndpoint(profile.getBaseUrl() + "api")
            .setAccess(profile.getAccessKey(), profile.getAccessSecret())
            .setCheckSign(profile.isCheckSign()).setEnableAutoRetry(profile.isEnableAutoRetry())
            .setAutoRetryLimit(profile.getAutoRetryLimit())
            .setHttpClient(client).setSecurityToken(securityToken);

        // build clients
        antCloudClient = antCloudClientBuilder.build();
        antCloudProdClient = antCloudProdClientBuilder.build();
        antCloudRestClient = antCloudRestClientBuilder.build();
    }

    public <T extends AntCloudResponse> T execute(AntCloudRequest<T> request) throws InterruptedException {
        return antCloudClient.execute(request);
    }

    public AntCloudClientResponse execute(AntCloudClientRequest request) throws InterruptedException {
        return antCloudClient.execute(request);
    }

    public <T extends AntCloudProdResponse> T execute(AntCloudProdRequest<T> request) throws InterruptedException {
        return antCloudProdClient.execute(request);
    }

    public AntCloudProdClientResponse execute(AntCloudProdClientRequest request) throws InterruptedException {
        return antCloudProdClient.execute(request);
    }

    public AntCloudRestClientResponse execute(AntCloudRestClientRequest request) {
        return antCloudRestClient.execute(request);
    }

}
